classdef class_REVS_battery_cell
	%UNTITLED3 Summary of this class goes here
	%   Detailed explanation goes here
	
	properties
		chemistry;									% Battery Chemistry from enum_battery_type
		initial_soc_norm;							% Initial cell state of charge [0-1]
% 		mass_kg;									
		
		
		capacity_Coulombs;							% Battery charge capacity [Culombs]
		powerlimit_discharge_map_W;					% Discharging Power Limit [Watts]
		powerlimit_charge_map_W;					% Charging Power Limit [Watts]
		powerlimit_map_index_soc_norm;				% Power Limit SOC Axis
		powerlimit_map_index_temp_degC;				% Power Limit Temperature Axis [degC]

		open_circuit_voltage_map_discharge_V;		% Open Circuit Voltage Map while Discharging [V]
		open_circuit_voltage_map_charge_V;			% Open Circuit Voltage Map while Charging [V]
		%open_circuit_voltage_map_average_V;			% Open Circuit Voltage Map Average of 
		open_circuit_voltage_map_index_temp_degC;	% Open Circuit Voltage Map Temperature Axis [degC]
		open_circuit_voltage_map_index_soc_norm;	% Open Circuit Voltage Map SOC Axis [0-1]
		use_average_open_circuit_Volts;				% Use Average Open Circut Voltage Map instead of charging & discharging maps

		transient_RC_index_soc_norm;				% Transient response RC constants SOC Axis [0-1]
		transient_RC_index_temp_degC;				% Transient response RC constants temperature Axis [degC]
		transient_R_discharge_short_term_Ohms;		% Transient response short term RC resistance when discharging [Ohms]
		transient_R_charge_short_term_Ohms;			% Transient response short term RC resistance when charging [Ohms]
		transient_R_discharge_long_term_Ohms;		% Transient response long term RC resistance when discharging [Ohms]
		transient_R_charge_long_term_Ohms;			% Transient response long term RC resistance when charging [Ohms]
		transient_C_discharge_short_term_Farads;	% Transient response short term RC capacitance when discharging [Farads]
		transient_C_charge_short_term_Farads;		% Transient response short term RC capacitance when charging [Farads]
		transient_C_discharge_long_term_Farads;		% Transient response long term RC capacitance when discharging [Farads]
		transient_C_charge_long_term_Farads;		% Transient response long term RC capacitance when charging [Farads]
		resistance_map_discharge_Ohms;				% Internal Resistance map while discharging [Ohms]
		resistance_map_charge_Ohms;					% Internal Resistance map while charging [Ohms]
		resistance_map_index_temp_degC;				% Internal Resistance map temperature axis [degC]
		resistance_map_index_soc_norm;				% Internal Resistance map SOC axis [0-1]

		charge_efficiency_map_norm;					% Charging efficiency map [0-1]
		charge_efficiency_index_temp_degC;			% Charging efficiency map temperature axis [degC]
		charge_efficiency_index_soc_norm;			% Charging efficiency map SOC axis
				
		temperature_power_derate_index_temp_degC;	% Power Limit Temperature Derate Axis [degC]
		temperature_power_discharge_derate_norm;	% Power Limit Temperature Derate map when discharging [0-1] 
		temperature_power_charge_derate_norm;		% Power Limit Temperature Derate map when charging [0-1]
		
	end
	
	properties (Dependent = true, Transient = true)
		capacity_nominal_Ah;						% Cell Nominal Capacity [Amp*Hours]
		
		open_circuit_voltage_map_average_V;			% Open Circuit Voltage Average of Charging & Discharging [V]
		
		open_circuit_voltage_map_V;					% Open Circuit Voltage Combined [V] - for future use
		transient_R_short_term_Ohms;				% Transient response short term RC resistance [Ohms] - for future use
		transient_R_long_term_Ohms;					% Transient response long term RC resistance [Ohms] - for future use
		transient_C_short_term_Fards;				% Transient response short term RC capacitance [Farads] - for future use
		transient_C_long_term_Fards;				% Transient response long term RC capacitance [Farads] - for future use
		resistance_map_Ohms;						% Internal Resistance Map [Ohms] - for future use
		
	end
		
		
	methods
		
		function obj = set.capacity_nominal_Ah(obj,val)
			obj.capacity_Coulombs = val * 3600;
		end
		
				
		function val = get.capacity_nominal_Ah(obj)
			val = obj.capacity_Coulombs / 3600;
		end
		
		
	end
	
end

